<?php

namespace App\Entity;

use App\Repository\DomaineRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=DomaineRepository::class)
 */
class Domaine
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $name;

    /**
     * @ORM\Column(type="datetime")
     */
    private $dateCreated;

    /**
     * @ORM\OneToMany(targetEntity=SqrGeneratedKeyDomaine::class, mappedBy="domaine")
     */
    private $sqrGeneratedKeyDomaines;

    public function __construct()
    {
        $this->sqrGeneratedKeyDomaines = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getDateCreated(): ?\DateTimeInterface
    {
        return $this->dateCreated;
    }

    public function setDateCreated(\DateTimeInterface $dateCreated): self
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * @return Collection<int, SqrGeneratedKeyDomaine>
     */
    public function getSqrGeneratedKeyDomaines(): Collection
    {
        return $this->sqrGeneratedKeyDomaines;
    }

    public function addSqrGeneratedKeyDomaine(SqrGeneratedKeyDomaine $sqrGeneratedKeyDomaine): self
    {
        if (!$this->sqrGeneratedKeyDomaines->contains($sqrGeneratedKeyDomaine)) {
            $this->sqrGeneratedKeyDomaines[] = $sqrGeneratedKeyDomaine;
            $sqrGeneratedKeyDomaine->setDomaine($this);
        }

        return $this;
    }

    public function removeSqrGeneratedKeyDomaine(SqrGeneratedKeyDomaine $sqrGeneratedKeyDomaine): self
    {
        if ($this->sqrGeneratedKeyDomaines->removeElement($sqrGeneratedKeyDomaine)) {
            // set the owning side to null (unless already changed)
            if ($sqrGeneratedKeyDomaine->getDomaine() === $this) {
                $sqrGeneratedKeyDomaine->setDomaine(null);
            }
        }

        return $this;
    }
}
